/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.capistrano.ui.wizard;

import com.aptana.core.logging.IdeLog;
import com.aptana.deploy.capistrano.CapistranoPlugin;
import com.aptana.deploy.capistrano.ui.wizard.CapifyProjectPage;
import com.aptana.deploy.capistrano.ui.wizard.InstallCapistranoGemPage;
import com.aptana.deploy.preferences.DeployPreferenceUtil;
import com.aptana.deploy.ui.wizard.AbstractDeployWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CapistranoDeployWizard
extends AbstractDeployWizard {
    private static final String IMG_PATH = "icons/newproj_wiz.png";

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setDefaultPageImageDescriptor(CapistranoPlugin.getImageDescriptor(IMG_PATH));
    }

    public void addPages() {
        super.addPages();
        if (InstallCapistranoGemPage.isCapistranoGemInstalled()) {
            this.addPage((IWizardPage)new CapifyProjectPage());
        } else {
            this.addPage((IWizardPage)new InstallCapistranoGemPage());
        }
    }

    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        CapifyProjectPage page = (CapifyProjectPage)currentPage;
        IRunnableWithProgress runnable = this.createCapifyRunnable(page);
        DeployPreferenceUtil.setDeployType((IContainer)this.getProject(), (String)"com.aptana.deploy.capistrano.provider");
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CapistranoPlugin.getDefault(), (Throwable)e);
        }
        return true;
    }

    protected IRunnableWithProgress createCapifyRunnable(CapifyProjectPage page) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                    IFile file = CapistranoDeployWizard.this.getProject().getFile(new Path("config").append("deploy.rb"));
                                    IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                                }
                                catch (PartInitException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    sub.done();
                }
            }
        };
    }
}

